<?php
/**
 * Common class that hold variable and function related to parser
 */

function insertGeoParseResult($r_mmsi, $r_mtime, $r_lat, $r_lon, $r_heading, $r_course, $r_speed, $log_file_name) {
	//  $isLogRawData          = ($r_mmsi == 316034846);
	$isLogRawData          = false;
	$DATA_UPSERT_MODE      = "INSERT";
	$debugLog              = "";
	$sqlSetSessionTimezone = "SET @@session.time_zone='-04:00';";
	$dateSession           = date('Y-m-d H:i:s');

	if ($r_heading >= 0 && $r_heading <= 359) {

	} else $r_heading = $r_course;

	$sql = "DELETE FROM ship_history_idx WHERE `timestamp` < (now() - interval 31+60 minute)";
	mysql_query($sql);

	// FIND OUT IS CURRENT POSITION IS INSIDE GEOFENCE, GET THE DETAIL DATA
	$sql = "SELECT
				input_mmsi,
				input_mtime,
				mmsi_info,
				mmsi_pic,
				trim(info.name) vessel_name,
				passinfo.location,
				hist.dest,
				passinfo.destination_eta,
				passinfo.destination_passage,
				passinfo.direction_lbl,
				'$dateSession',
				'geoParser'
			FROM
				shipinfo info
				LEFT JOIN ship_moreinfo moreinfo ON moreinfo.mmsi = info.mmsi
				INNER JOIN (
					select mmsi, dest from ship_history_idx where mmsi = '$r_mmsi' order by mtime desc limit 1
				) hist ON info.mmsi = hist.mmsi
				INNER JOIN (
					SELECT
						'$r_mmsi' input_mmsi,
						FROM_UNIXTIME($r_mtime) input_mtime,
						dir_pass.port_location location,
						CASE
						WHEN dir_pass.dest_distance is NULL
							THEN date_add(FROM_UNIXTIME($r_mtime), interval eta_addition minute)
							ELSE date_add(FROM_UNIXTIME($r_mtime), interval (((dir_pass.dest_distance / $r_speed) * 60) + coalesce(dir_pass.minute_adjustment, 0)) minute)
						END destination_eta,
						dir_pass.direction_lbl,
						dir_pass.log_to_passage destination_passage
					FROM
						v_passage pass
					INNER JOIN v_passage_direction dir_pass ON pass.id = dir_pass.active_on_passage
					INNER JOIN `port` ON `port`.id = dir_pass.port_location
					WHERE
						ST_CONTAINS (
							geom,
							point (
								$r_lon,
								$r_lat
							)
						)
						and case
							when ((heading - 20) >= 0 and (heading + 20) <= 360)
								and ($r_heading between (heading - 20) and (heading + 20))
									then 'inrange'
							when ((heading - 20) < 0) then
								case
									when ($r_heading between (360 + (heading - 20)) and 360 or $r_heading between 0 and (heading + 20)) then 'inrange'
								end
							when ((heading + 20) > 360) then
								case
									when ($r_heading between (heading - 20) and 360 or $r_heading between 0 and ((heading + 20)-360)) then 'inrange'
								end
							else 'not in any range'
						end = 'inrange'
						and $r_speed >= dir_pass.speed
						and `port`.is_hidden = 'n'
				) passinfo ON passinfo.input_mmsi = info.mmsi
			WHERE
				info.mmsi = '$r_mmsi'
			GROUP BY input_mmsi, input_mtime, destination_passage";

	$result = mysql_query($sql);
	$numResults = mysql_num_rows($result);
	$counter = 0;
	while ($res = mysql_fetch_array($result)) {
		$currMMSI               = $res['input_mmsi'];
		$currGPSTime            = $res['input_mtime'];
		$currMMSI_info          = $res['mmsi_info'];
		$currMMSI_pic           = $res['mmsi_pic'];
		$currVesselName         = $res['vessel_name'];
		$currLocation           = $res['location'];
		$currDestination        = ucwords(strtolower($res['dest']));
		$currDestinationETA     = $res['destination_eta'];
		$currDestinationPassage = $res['destination_passage'];
		$currDirectionLbl       = $res['direction_lbl'];

		if ($counter == 0) {
			$debugLog .= PHP_EOL.">>> vessel $currVesselName at $currGPSTime inside geofence".PHP_EOL;
		}
		if ($isLogRawData) $debugLog .= ">>> location: '$currLocation', heading: '$r_heading', direction: $currDirectionLbl, destination: ".ucwords(strtolower(trim($currDestination))).", dest passage: $currDestinationPassage".PHP_EOL;

		//	BEGIN OF GET TRIP INFORMATION FOR THE LAST 8 HOURS
		$sql =
		"SELECT id, gps_time, location, destination, destination_passage, direction_lbl, cargo, comments, overrided
		FROM v_passage_result
		WHERE
			mmsi = '$r_mmsi' and
			is_deleted != 1 and
			location = '$currLocation' and
			destination_passage = '$currDestinationPassage' and
			direction_lbl = '$currDirectionLbl' and
			TIMESTAMPDIFF(HOUR, gps_time, '$currGPSTime') between 0 and 8
		ORDER BY gps_time DESC LIMIT 1";

		$pastLocation           = '';
		$pastGPSTime            = '';
		$pastDestination        = '';
		$pastDestinationPassage = '';
		$pastDirectionLabel     = '';
		$pastCargo              = '';
		$pastComments           = '';
		$pastOverrided          = '';
		$lastPassageDest        = mysql_query($sql);
		$ctrLastPassageDest     = 0;

		while ($res_passage_dest = mysql_fetch_array($lastPassageDest)) {
			$ctrLastPassageDest++;
			if ($ctrLastPassageDest > 0) {
				$pastID                 = $res_passage_dest['id'];
				$pastGPSTime            = $res_passage_dest['gps_time'];
				$pastLocation           = $res_passage_dest['location'];
				$pastDestination        = $res_passage_dest['destination'];
				$pastDestinationPassage = $res_passage_dest['destination_passage'];
				$pastDirectionLabel     = $res_passage_dest['direction_lbl'];
				$pastCargo              = $res_passage_dest['cargo'];
				$pastComments           = $res_passage_dest['comments'];
				$pastOverrided          = $res_passage_dest['overrided'];

				//	TRIP INFORMATION RELATED PROCESS
				//	IF PAST LOCATION == CURRENT PASSAGE DESTINATION THEN GET PAST TRIP INFORMATION
				//	IF PAST LOCATION != CURRENT PASSAGE DESTINATION THEN CLEAR TRIP INFORMATION
				if ($pastLocation == $currDestinationPassage) {
					//	VESSEL HEADING TO SAME PASSAGE DESTINATION, USE PAST TRIP INFORMATION
				} else if ($pastLocation != $currDestinationPassage) {
					//	VESSEL HEADING TO DIFFERENT PASSAGE DESTINATION, CLEAR TRIP INFORMATION
					$pastDestination = '';
					$pastCargo       = '';
					$pastComments    = '';
					$pastOverrided   = '';
				}

				//	CHECKING CURRENT POSITION IS THE SAME AS LAST ONE (SAME GEOZONE)
				//	BY CHECKING CURRENT LOCATION, DESTINATION PASSAGE AND DIRECTION LABEL
				//	IF IT'S SAME LOCATION DO UPDATE CURRENT ROW
				//	IF IT'S DIFFERENT LOCATION DO INSERT NEW ROW

				if ($currLocation == $pastLocation &&
					$currDestinationPassage == $pastDestinationPassage &&
					$currDirectionLbl == $pastDirectionLabel
				) {
					//	UPDATE PAST ROW ID
					$DATA_UPSERT_MODE = "UPDATE";
				} else {
					//	INSERT NEW ROW
					$DATA_UPSERT_MODE = "INSERT";
				}
			}
		}
		//  $debugLog .= "ctrLastPassageDest: $ctrLastPassageDest, currDestinationPassage: $currDestinationPassage".PHP_EOL;

		//	IF VESSEL IS MOVING TO DIFFERENT LOCATION BUT SAME PASSAGE DESTINATION
		if ($ctrLastPassageDest == 0) {
			$sql =
			"SELECT res.id, gps_time, location, destination, destination_passage, direction_lbl, cargo, comments, overrided
			FROM v_passage_result res
			INNER JOIN `port` ON `port`.id = res.location
			WHERE
				mmsi = '$r_mmsi' and
				is_deleted != 1 and
				destination_passage = '$currDestinationPassage' and
				direction_lbl = '$currDirectionLbl' and
				(TIMESTAMPDIFF(HOUR, gps_time, '$currGPSTime') between 0 and 8) and
				`port`.is_hidden = 'n'
			ORDER BY gps_time DESC LIMIT 1";
			$lastPassageDest = mysql_query($sql);

			while ($res_passage_dest = mysql_fetch_array($lastPassageDest)) {
				//	UPDATE PAST ROW ID
				$DATA_UPSERT_MODE       = "UPDATE";
				$pastID                 = $res_passage_dest['id'];
				$pastGPSTime            = $res_passage_dest['gps_time'];
				$pastLocation           = $res_passage_dest['location'];
				$pastDestination        = $res_passage_dest['destination'];
				$pastDestinationPassage = $res_passage_dest['destination_passage'];
				$pastDirectionLabel     = $res_passage_dest['direction_lbl'];
				$pastCargo              = $res_passage_dest['cargo'];
				$pastComments           = $res_passage_dest['comments'];
				$pastOverrided          = $res_passage_dest['overrided'];
			}
		}
		//	END OF GET TRIP INFORMATION FOR THE LAST 8 HOURS

		if ($DATA_UPSERT_MODE == "INSERT") {
			$debugLog .= ">>> inserting new data vessel passage".PHP_EOL;
			$sql =
			"INSERT INTO v_passage_result (mmsi, gps_time, vessel_info_link, vessel_picture_link, vessel_name, location, destination, destination_eta, destination_passage,  direction_lbl, cargo, comments, ts_entergeo, datein, userin, overrided, raw_data)
			SELECT
				'$currMMSI',
				'$currGPSTime',
				'$currMMSI_info',
				'$currMMSI_pic',
				'$currVesselName',
				'$currLocation',
				'$currDestination',
				'$currDestinationETA',
				'$currDestinationPassage',
				'$currDirectionLbl',
				'$pastCargo',
				'$pastComments',
				'$dateSession',
				'$dateSession',
				'geoParser',
				'$pastOverrided',
				''";
			mysql_query($sql);
		} else if ($DATA_UPSERT_MODE == "UPDATE") {
			$debugLog .= ">>> updating data vessel passage rowID: $pastID".PHP_EOL;

			$sql =
			"UPDATE v_passage_result
			SET
				gps_time = '$currGPSTime',
				location = '$currLocation',
				destination = '$currDestination',
				destination_eta = '$currDestinationETA',
				dateup = '$dateSession'
			WHERE id = $pastID";
			mysql_query($sql);
		}

		if (++$counter == $numResults) {
			// DELETE OLD DATA WHICH IT'S LOCATION IS NOT PASSAGE DESTINATION
			$sqlDel = "DELETE
					FROM
						v_passage_result res
					WHERE
						(location != destination_passage)
						AND mmsi = '$r_mmsi'
						AND gps_time < '$currGPSTime'";
			mysql_query($sqlDel);
		}
		$DATA_UPSERT_MODE = "INSERT";
	}
	$currGPSTime = str_replace(" ", "T", $currGPSTime);
	$pastGPSTime = str_replace(" ", "T", $pastGPSTime);
	$dtCurrGPSTime = new DateTime($currGPSTime);
	$dtPastGPSTime = new DateTime($pastGPSTime);
	$diffInMinutes = diffDateInMinutes($dtCurrGPSTime, $dtPastGPSTime);

	if ($isLogRawData && ($diffInMinutes > 10 || $currLocation != $pastLocation)) file_put_contents($log_file_name, $debugLog, FILE_APPEND);
	//  if ($isLogRawData) file_put_contents($log_file_name, $debugLog, FILE_APPEND);
}

function detectRequestBody() {
	$rawInput   = fopen('php://input', 'r');
	$tempStream = fopen('php://temp', 'r+');
	stream_copy_to_stream($rawInput, $tempStream);
	rewind($tempStream);
	return $tempStream;
}

function diffDateInMinutes($date1, $date2) {
	$diff = $date2->diff($date1);

	$minutes = $diff->days * 24 * 60;
	$minutes += $diff->h * 60;
	$minutes += $diff->i;
	return $minutes;
}

?>
